/*********************************************************************************************************//**
 * @file    BC3603.h
 * @version $Rev:: 5827         $
 * @date    $Date:: 2022-08-30 #$
 * @brief   The header file of the RF library.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BC3603_SPI_H
#define __BC3603_SPI_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------*/
#include "ht32.h"

// <<< Use Configuration Wizard in Context Menu >>>


/* Interface Definitions -----------------------------------------------------------------------*/
/** @defgroup BC3603 SPI Interface
  * @{
  */  
/***********************************************************************************************
BC3603 Interface Caption:
	1. MCU		RF
		PA3----->CSN	: chip select pin
		PA0----->SCK	: SPI clock
		PA1----->SDIO	: SPI	data in or out(3-wires)
		PA2<-----GIO1	: SPI data out(4-wires)
		PC4<-----GIO2	: Interrupt request(IRQ),Optional other MCU I/O.
	2. Interface configure to SPI 4-wires
	3. MCU WAKEUP pin rising edge,RF IRQPOP configure to active high 
************************************************************************************************/
#define	RFINF_FW_SPI				0
#define	RFINF_HW_SPI				1
  
//	<h> SPI mode Configuration
//		<o RFINF_SPI> SPI mode
//    	<RFINF_FW_SPI=> F/W SPI
//       <RFINF_HW_SPI=> H/W SPI
#define	RFINF_SPI					(RFINF_HW_SPI)
//	</h>  

#define	SPI_CSN_PORT				HT_GPIOA
#define  SPI_CSN   					GPIO_PIN_3					/*PA3*/
#define	SPI_CSN_AFIO_PORT			GPIO_PA
#if	(RFINF_SPI == RFINF_FW_SPI)
#define	SPI_CSN_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	SPI_CSN_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	SPI_SCK_PORT				HT_GPIOA
#define  SPI_SCK   					GPIO_PIN_0					/*PA0*/
#define	SPI_SCK_AFIO_PORT			GPIO_PA
#if	(RFINF_SPI == RFINF_FW_SPI)
#define	SPI_SCK_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	SPI_SCK_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	SPI_MOSI_PORT				HT_GPIOA
#define  SPI_MOSI   					GPIO_PIN_1					/*PA1*/
#define	SPI_MOSI_AFIO_PORT		GPIO_PA
#if	(RFINF_SPI == RFINF_FW_SPI)
#define	SPI_MOSI_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	SPI_MOSI_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	SPI_MISO_PORT				HT_GPIOA
#define  SPI_MISO   					GPIO_PIN_2					/*PA2*/
#define	SPI_MISO_AFIO_PORT		GPIO_PA
#if	(RFINF_SPI == RFINF_FW_SPI)
#define	SPI_MISO_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	SPI_MISO_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	RF_IRQ_PORT					HT_GPIOC
#define  RF_IRQ   					GPIO_PIN_4					/*PC4*/
#define	RF_IRQ_AFIO_PORT			GPIO_PC
#define	RF_IRQ_AFIO_FUN			AFIO_FUN_GPIO
#define	RF_IRQ_AFIO_ESS			AFIO_ESS_PC
#define	RF_IRQ_EXIT_CH				AFIO_EXTI_CH_4
#define	RF_IRQn						EXTI4_15_IRQn
#define	RF_IRQHandler				EXTI4_15_IRQHandler

#if	(RFINF_SPI == RFINF_FW_SPI)
#define	SPI_ACTIVE()				(SPI_CSN_PORT->RR = SPI_CSN)
#define	SPI_INACTIVE() 			(SPI_CSN_PORT->SRR = SPI_CSN)
#define	SPISCK_SET()				(SPI_SCK_PORT->SRR = SPI_SCK)
#define	SPISCK_RESET()				(SPI_SCK_PORT->RR = SPI_SCK)
#define	SPIMOSI_SET()				(SPI_MOSI_PORT->SRR = SPI_MOSI)
#define	SPIMOSI_RESET()			(SPI_MOSI_PORT->RR = SPI_MOSI)
#define	SPIMISO_IN()				(SPI_MISO_PORT->DINR &= SPI_MISO)
#else
#define	RFSPI							HT_SPI1
#define	RFSPI_PCLK					CKCU_PCLK_SPI1
//	<h> H/W SPI Speed Configuration
//		<o> SPI Speed<1000-10000000>
#define	RFSPI_SPEED					(2500000UL)
//	</h>
#define	SPI_ACTIVE()				(RFSPI->CR0 |= SPI_SEL_ACTIVE)
#define	SPI_INACTIVE() 			(RFSPI->CR0 &= SPI_SEL_INACTIVE)
#endif

#define	RFIRQ_IN()					(RF_IRQ_PORT->DINR &= RF_IRQ)

//	<o> SDO(MISO) and IRQ Line Select
//		<0=> GIO1:MISO,GIO2:IRQ
//		<1=> GIO2:MISO,GIO1:IRQ
#define _SDO_IRQ_LINE_				(0)

//	<o> IRQ Active Polarity Select
//		<0=> Low Active
//		<1=> High Active
#define _IRQ_POLARITY_  			(0)

/**
  * @}
  */


/* Exported types ------------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Types RF exported types
  * @{
  */

/**
  * @}
  */


/* Exported functions --------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Functions RF exported functions
  * @{
  */  

void 	BC3603_InterfaceConfigure(void);
void 	BC3603_IRQExtiConfigure(void);
void 	BC3603_IRQExtiControl(ControlStatus NewState);
FlagStatus BC3603_IRQLineStatus(void);

void	BC3603_StrobeCommand(u8 Cmd);
u8 	BC3603_ReadRegister(u8 Addr);
void 	BC3603_WriteRegister(u8 Addr,u8 Data);
void 	BC3603_ReadMultipleRegister(u8 Cmd,u8 *DstAddr,u16 Length);
void 	BC3603_WriteMultipleRegister(u8 Cmd,u8 *SrcAddr,u16 Length);


/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif
